#!/bin/bash
# dz/ct 26.04.2010
# Annonciert TimeMachine-Service fuer aktuellen Mac

# abwarten, bis IP-Konfiguration gesetzt ist
# Achtung: das ist nur eine krude Methode, jedes LAN-Interface
# kann dieses Kommando triggern, also auch virtuelle Interfaces
# von VirtualBox, Parallels, Fusion und so weiter
/usr/sbin/ipconfig waitall

#Bonjour-Hostnamen, IP-Adresse und Namen der Boot-Partition auslesen
BonjourHostname=`/usr/sbin/networksetup getcomputername`
IPAdresse=`(/usr/sbin/system_profiler SPNetworkDataType | sed -ne '/IPv4 Addresses/ s/.* //p')`
BootPartition=`(/usr/sbin/system_profiler SPSoftwareDataType | sed -ne '/Boot Volume/ s/.* //p')`

# Debug-Output fuer Konsole
echo "$BonjourHostname""-TM"
echo $IPAdresse
echo $BootPartition

# Autodisk-Dienst fur lokale Machine annoncieren
# dk0 : Erste Partition
# dk1 waere zweite Partition, dk2 die dritte, etc.
/usr/bin/dns-sd -P "$BonjourHostname""-TM" _adisk._tcp. local 9 "$BonjourHostname""-TM.local" $IPAdresse sys=waMA=0,adVF=0x100 dk0=adVN=$BootPartition,adVF=0xa1,adVU=0
